import { convertIntegrationFnToClass } from '@sentry/core';
import { ElectronRendererMetricsAggregator } from '../metrics.js';

const INTEGRATION_NAME = 'MetricsAggregator';
const metricsAggregatorIntegration = () => {
    return {
        name: INTEGRATION_NAME,
        setup(client) {
            client.metricsAggregator = new ElectronRendererMetricsAggregator();
        },
    };
};
/**
 * Enables Sentry metrics monitoring.
 *
 * @experimental This API is experimental and might having breaking changes in the future.
 */
// eslint-disable-next-line deprecation/deprecation
const MetricsAggregator = convertIntegrationFnToClass(INTEGRATION_NAME, metricsAggregatorIntegration);

export { MetricsAggregator };
//# sourceMappingURL=metrics-aggregator.js.map
