/**
 * @license
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { LitElement, PropertyValues, TemplateResult } from 'lit';
/** @soyCompatible */
export declare class CircularProgressBase extends LitElement {
    indeterminate: boolean;
    progress: number;
    density: number;
    closed: boolean;
    /** @soyPrefixAttribute */
    ariaLabel: string;
    open(): void;
    close(): void;
    /**
     * @soyTemplate
     */
    protected render(): TemplateResult;
    /**
     * @soyTemplate
     */
    protected renderDeterminateContainer(): TemplateResult;
    /**
     * @soyTemplate
     */
    protected renderIndeterminateContainer(): TemplateResult;
    /**
     * @soyTemplate
     */
    protected renderIndeterminateSpinnerLayer(): TemplateResult;
    update(changedProperties: PropertyValues<this>): void;
}
