/// <reference types="node" />
import Stream from 'stream';
import { Context } from 'koa';
export declare function setDebug(debug: boolean): void;
export declare function logDebug(...messages: any[]): void;
export declare class RequestCancelledError extends Error {
}
export declare class IsBinaryFileError extends Error {
}
export declare function isUtf8(context: Context): boolean;
/**
 * Returns the body value as string. If the response is a stream, the
 * stream is drained and the result is returned. Because koa-static stores
 * a path variable on the stream, we need to create a new stream with
 * the same variable to preserve correct behavior.
 *
 */
export declare function getBodyAsString(ctx: Context): Promise<string>;
/**
 * Turns a file path into a path suitable for browsers, with a / as seperator.
 * @param {string} filePath
 * @returns {string}
 */
export declare function toBrowserPath(filePath: string): string;
/**
 * Transforms a file system path to a browser URL. For example windows uses `\` on the file system,
 * but it should use `/` in the browser.
 */
export declare function toFilePath(browserPath: string): string;
export declare class SSEStream extends Stream.Transform {
    sendMessage(name: string, data?: string): void;
    _transform(data: string, enc: string, cb: () => void): void;
}
export declare function isPolyfill(url: string): boolean;
export declare function shouldTransformToModule(url: string): boolean;
export declare function isInlineScript(url: string): boolean;
/**
 * Returns whether this is a file generated generated by the dev server
 */
export declare function isGeneratedFile(url: string): boolean;
export declare function getRequestFilePath(ctx: Context, rootDir: string): string | null;
