import { TransformOptions } from '@babel/core';
interface CreateBabelTransformConfig {
    browserTarget: string | string[];
    polyfillModules?: boolean;
    readUserBabelConfig?: boolean;
    customBabelConfig?: TransformOptions;
}
export declare type BabelTransform = (filename: string, source: string) => Promise<string>;
export declare const defaultConfig: TransformOptions;
/**
 * Creates a babel compiler backed by an in-memory last-read-out cache. Sets up configuration
 * based on a number of presets.
 */
export declare function createBabelTransform(cfg: {
    readUserBabelConfig?: boolean;
    customBabelConfig?: TransformOptions;
}, baseConfig?: TransformOptions): (filename: string, source: string) => Promise<string>;
export declare function createCompatibilityBabelTransform(cfg: CreateBabelTransformConfig): (filename: string, source: string) => Promise<string>;
export declare function createMinCompatibilityBabelTransform(cfg: Partial<CreateBabelTransformConfig>): (filename: string, source: string) => Promise<string>;
export declare function createMaxCompatibilityBabelTransform(cfg: Partial<CreateBabelTransformConfig>): (filename: string, source: string) => Promise<string>;
/**
 * transform for only polyfilling modules, this should be run after the compatibility
 * config where all js is already compiled to a compatible format. we therefore don't
 * include any extra plugins or user configuration
 */
export declare const polyfillModulesTransform: (filename: string, source: string) => Promise<string>;
export {};
