"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.nodeResolvePlugin = void 0;
const tslib_1 = require("tslib");
const plugin_node_resolve_1 = tslib_1.__importDefault(require("@rollup/plugin-node-resolve"));
const path_1 = tslib_1.__importDefault(require("path"));
const whatwg_url_1 = tslib_1.__importDefault(require("whatwg-url"));
const utils_1 = require("../utils/utils");
const nodeResolvePackageJson = require('@rollup/plugin-node-resolve/package.json');
const fakePluginContext = {
    meta: {
        rollupVersion: nodeResolvePackageJson.peerDependencies.rollup,
    },
    warn(...msg) {
        console.warn('[es-dev-server] node-resolve: ', ...msg);
    },
};
function nodeResolvePlugin(config) {
    var _a, _b;
    const { fileExtensions, rootDir } = config;
    const options = {
        rootDir,
        // allow resolving polyfills for nodejs libs
        preferBuiltins: false,
        extensions: fileExtensions,
        ...(typeof config.nodeResolve === 'object' ? config.nodeResolve : {}),
    };
    const nodeResolve = plugin_node_resolve_1.default(options);
    // call buildStart
    const preserveSymlinks = (_a = options === null || options === void 0 ? void 0 : options.customResolveOptions) === null || _a === void 0 ? void 0 : _a.preserveSymlinks;
    (_b = nodeResolve.buildStart) === null || _b === void 0 ? void 0 : _b.call(fakePluginContext, { preserveSymlinks });
    return {
        async serverStart({ config }) { },
        async resolveImport({ source, context }) {
            var _a;
            if (!path_1.default.isAbsolute(source) && whatwg_url_1.default.parseURL(source) != null) {
                // don't resolve relative and valid urls
                return source;
            }
            const [withoutHash, hash] = source.split('#');
            const [importPath, params] = withoutHash.split('?');
            const relativeImport = importPath.startsWith('.') || importPath.startsWith('/');
            const jsFileImport = fileExtensions.includes(path_1.default.extname(importPath));
            // for performance, don't resolve relative imports of js files. we only do this for js files,
            // because an import like ./foo/bar.css might actually need to resolve to ./foo/bar.css.js
            if (relativeImport && jsFileImport) {
                return source;
            }
            const requestedFile = context.path.endsWith('/') ? `${context.path}index.html` : context.path;
            const filePath = path_1.default.join(rootDir, requestedFile);
            // do the actual resolve using the rolluo plugin
            const result = await ((_a = nodeResolve.resolveId) === null || _a === void 0 ? void 0 : _a.call(fakePluginContext, importPath, filePath));
            let resolvedImportFilePath;
            if (result) {
                if (typeof result === 'string') {
                    resolvedImportFilePath = result;
                }
                else if (typeof result.id === 'string') {
                    resolvedImportFilePath = result.id;
                }
            }
            if (!resolvedImportFilePath) {
                throw new Error(`Could not resolve import "${importPath}" in "${path_1.default.relative(process.cwd(), filePath)}".`);
            }
            const resolveRelativeTo = path_1.default.extname(filePath) ? path_1.default.dirname(filePath) : filePath;
            const relativeImportFilePath = path_1.default.relative(resolveRelativeTo, resolvedImportFilePath);
            const suffix = `${params ? `?${params}` : ''}${hash ? `#${hash}` : ''}`;
            const resolvedImportPath = `${utils_1.toBrowserPath(relativeImportFilePath)}${suffix}`;
            return resolvedImportPath.startsWith('/') || resolvedImportPath.startsWith('.')
                ? resolvedImportPath
                : `./${resolvedImportPath}`;
        },
    };
}
exports.nodeResolvePlugin = nodeResolvePlugin;
//# sourceMappingURL=nodeResolvePlugin.js.map