"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWatchServedFilesMiddleware = void 0;
const utils_1 = require("../utils/utils");
async function watchServedFile(ctx, cfg) {
    const filePath = utils_1.getRequestFilePath(ctx, cfg.rootDir);
    if (!filePath || utils_1.isGeneratedFile(ctx.url)) {
        return;
    }
    cfg.fileWatcher.add(filePath);
}
/**
 * Sets up a middleware which tracks served files and sends a reload message to any
 * active browsers when any of the files change.
 */
function createWatchServedFilesMiddleware(cfg) {
    return async function watchServedFilesMiddleware(ctx, next) {
        await next();
        watchServedFile(ctx, cfg);
    };
}
exports.createWatchServedFilesMiddleware = createWatchServedFilesMiddleware;
//# sourceMappingURL=watch-served-files.js.map