"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBasePathMiddleware = void 0;
/**
 * Creates middleware which strips a base path from each request
 */
function createBasePathMiddleware(cfg) {
    return function basePathMiddleware(ctx, next) {
        if (ctx.url.startsWith(cfg.basePath)) {
            ctx.url = ctx.url.replace(cfg.basePath, '');
        }
        return next();
    };
}
exports.createBasePathMiddleware = createBasePathMiddleware;
//# sourceMappingURL=base-path.js.map