/// <reference types="node" />
import Koa from 'koa';
import chokidar from 'chokidar';
import net from 'net';
import { ParsedConfig } from './config';
/**
 * Creates a koa server with middlewares, but does not start it. Returns the koa app and
 * http server instances.
 */
export declare function createServer(cfg: ParsedConfig, fileWatcher?: chokidar.FSWatcher): {
    server: net.Server;
    app: Koa<Koa.DefaultState, Koa.DefaultContext>;
    onServerStarted: (app: Koa<Koa.DefaultState, Koa.DefaultContext>, server: net.Server) => Promise<void>;
};
