interface Location {
    filePath: string;
    line: number;
    column: number;
}
export interface StackLocation extends Location {
    browserUrl: string;
}
export type MapStackLocation = (location: StackLocation) => StackLocation | Promise<StackLocation>;
export type MapBrowserUrl = (url: URL) => string;
export interface ParseStackTraceOptions {
    browserRootDir?: string;
    cwd?: string;
    mapBrowserUrl?: MapBrowserUrl;
    mapStackLocation?: MapStackLocation;
}
export declare function parseStackTrace(errorMsg: string, rawStack: string, options?: ParseStackTraceOptions): Promise<string | undefined>;
export {};
//# sourceMappingURL=parseStackTrace.d.ts.map