# Installation
> `npm install --save @types/karma-mocha`

# Summary
This package contains type definitions for karma-mocha (https://github.com/karma-runner/karma-mocha#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/karma-mocha.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/karma-mocha/index.d.ts)
````ts
// Type definitions for karma-mocha 1.3
// Project: https://github.com/karma-runner/karma-mocha#readme
// Definitions by: Piotr Błażejewicz (Peter Blazejewicz) <https://github.com/peterblazejewicz>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 3.2

import "karma";

declare module "karma" {
    interface ClientOptions {
        mocha?: MochaClientOptions | undefined;
    }

    interface MochaClientOptions {
        /** This will be exposed in a reporter as `result.mocha.{exportedValue}` */
        export?: string[] | undefined;
        /** You can set opts to equal true then plugin will load opts from default location 'test/mocha.opts' */
        opts?: true | string | undefined;
        /** any supported Mocha configuration options */
        [key: string]: any;
    }
}

````

### Additional Details
 * Last updated: Thu, 14 Sep 2023 01:49:18 GMT
 * Dependencies: [@types/karma](https://npmjs.com/package/@types/karma)
 * Global values: none

# Credits
These definitions were written by [Piotr Błażejewicz (Peter Blazejewicz)](https://github.com/peterblazejewicz).
