import { Args, ComponentAnnotations, AnnotatedStoryFn, StoryAnnotations, StrictArgs, DecoratorFunction, LoaderFunction, StoryContext as StoryContext$1, ProjectAnnotations } from 'storybook/internal/types';
export { ArgTypes, Args, Parameters, StrictArgs } from 'storybook/internal/types';
import { W as WebComponentsRenderer } from './types-9976a2c9.js';
import 'lit';

/**
 * Metadata to configure the stories for a component.
 *
 * @see [Default export](https://storybook.js.org/docs/formats/component-story-format/#default-export)
 */
type Meta<TArgs = Args> = ComponentAnnotations<WebComponentsRenderer, TArgs>;
/**
 * Story function that represents a CSFv2 component example.
 *
 * @see [Named Story exports](https://storybook.js.org/docs/formats/component-story-format/#named-story-exports)
 */
type StoryFn<TArgs = Args> = AnnotatedStoryFn<WebComponentsRenderer, TArgs>;
/**
 * Story object that represents a CSFv3 component example.
 *
 * @see [Named Story exports](https://storybook.js.org/docs/formats/component-story-format/#named-story-exports)
 */
type StoryObj<TArgs = Args> = StoryAnnotations<WebComponentsRenderer, TArgs>;
type Decorator<TArgs = StrictArgs> = DecoratorFunction<WebComponentsRenderer, TArgs>;
type Loader<TArgs = StrictArgs> = LoaderFunction<WebComponentsRenderer, TArgs>;
type StoryContext<TArgs = StrictArgs> = StoryContext$1<WebComponentsRenderer, TArgs>;
type Preview = ProjectAnnotations<WebComponentsRenderer>;

declare function isValidComponent(tagName: string): boolean;
declare function isValidMetaData(customElements: any): boolean;
/**
 * @param customElements any for now as spec is not super stable yet
 */
declare function setCustomElements(customElements: any): void;
declare function setCustomElementsManifest(customElements: any): void;
declare function getCustomElements(): any;

export { Decorator, Loader, Meta, Preview, StoryContext, StoryFn, StoryObj, WebComponentsRenderer, getCustomElements, isValidComponent, isValidMetaData, setCustomElements, setCustomElementsManifest };
