import { Integrations } from '@sentry/core';
export { Hub, SDK_VERSION, Scope, addBreadcrumb, addEventProcessor, addGlobalEventProcessor, addIntegration, captureCheckIn, captureEvent, captureException, captureMessage, close, configureScope, continueTrace, createTransport, extractTraceparentData, flush, getActiveSpan, getActiveTransaction, getClient, getCurrentHub, getCurrentScope, getGlobalScope, getHubFromCarrier, getIsolationScope, lastEventId, makeMain, metrics, runWithAsyncContext, setContext, setExtra, setExtras, setMeasurement, setTag, setTags, setUser, spanStatusfromHttpCode, startActiveSpan, startInactiveSpan, startSpan, startSpanManual, startTransaction, trace, withMonitor, withScope } from '@sentry/core';
export { autoDiscoverNodePerformanceMonitoringIntegrations } from './tracing/index.js';
export { NodeClient } from './client.js';
export { makeNodeTransport } from './transports/http.js';
export { defaultIntegrations, defaultStackParser, getSentryRelease, init } from './sdk.js';
export { DEFAULT_USER_INCLUDES, addRequestDataToEvent, extractRequestData } from '@sentry/utils';
export { deepReadDirSync } from './utils.js';
export { getModuleFromFilename } from './module.js';
export { enableAnrDetection } from './integrations/anr/legacy.js';
import * as handlers from './handlers.js';
export { handlers as Handlers };
import * as index from './integrations/index.js';
import * as integrations from './tracing/integrations.js';
export { hapiErrorPlugin } from './integrations/hapi/index.js';
import { instrumentCron } from './cron/cron.js';
import { instrumentNodeCron } from './cron/node-cron.js';

const INTEGRATIONS = {
  ...Integrations,
  // This typecast is somehow needed for now, probably because of the convertIntegrationFnToClass TS shenanigans
  // This is OK for now but should be resolved in v8 when we just pass the functional integrations directly
  ...(index

),
  ...integrations,
};

/** Methods to instrument cron libraries for Sentry check-ins */
const cron = {
  instrumentCron,
  instrumentNodeCron,
};

export { INTEGRATIONS as Integrations, cron };
//# sourceMappingURL=index.js.map
