const tslib = require('tslib');
const core = require('@sentry/core');
const ipc = require('./ipc.js');

/**
 * Creates a Transport that passes envelopes to the Electron main process.
 */
function makeRendererTransport(options) {
    const ipc$1 = ipc.getIPC();
    return core.createTransport(options, (request) => tslib.__awaiter(this, void 0, void 0, function* () {
        ipc$1.sendEnvelope(request.body);
        // Since the main process handles sending of envelopes and rate limiting, we always return 200 OK to the renderers.
        return { statusCode: 200 };
    }));
}

exports.makeRendererTransport = makeRendererTransport;
//# sourceMappingURL=transport.js.map
