const node = require('@sentry/node');
const electron = require('electron');
const electronNormalize = require('../electron-normalize.js');

// We can't use the functional style of integration until they are exported as functions...
/**
 * Starts a worker thread to detect App Not Responding (ANR) events
 */
class Anr extends node.Integrations.Anr {
    constructor(options = {}) {
        if (electronNormalize.ELECTRON_MAJOR_VERSION < 22) {
            throw new Error('Main process ANR detection requires Electron v22+');
        }
        super(Object.assign(Object.assign({}, options), { staticTags: Object.assign({ 'event.environment': 'javascript', 'event.origin': 'electron', 'event.process': 'browser' }, options.staticTags), appRootPath: electron.app.getAppPath() }));
    }
}

exports.Anr = Anr;
//# sourceMappingURL=anr.js.map
