import { getModuleFromFilename as getModuleFromFilename$1 } from '@sentry/node';
import { createStackParser, nodeStackLineParser, normalizeUrlToBase } from '@sentry/utils';
import { app } from 'electron';

/** Parses the module name form a filename */
function getModuleFromFilename(filename) {
    if (!filename) {
        return;
    }
    const normalizedFilename = normalizeUrlToBase(filename, app.getAppPath());
    return getModuleFromFilename$1(normalizedFilename);
}
// node.js stack parser but filename normalized before parsing the module
const defaultStackParser = createStackParser(nodeStackLineParser(getModuleFromFilename));

export { defaultStackParser };
//# sourceMappingURL=stack-parse.js.map
