/** Starts a session */
export declare function startSession(sendOnCreate: boolean): void;
/** Cleanly ends a session */
export declare function endSession(): Promise<void>;
/** Determines if a Date is likely to have occurred in the previous uncompleted session */
export declare function unreportedDuringLastSession(crashDate: Date | undefined): Promise<boolean>;
/** Checks if the previous session needs sending as crashed or abnormal  */
export declare function checkPreviousSession(crashed: boolean): Promise<void>;
/** Sets the current session as crashed */
export declare function sessionCrashed(): void;
/** Sets the current session as ANR */
export declare function sessionAnr(): void;
/**
 * End the current session on app exit
 */
export declare function endSessionOnExit(): void;
//# sourceMappingURL=sessions.d.ts.map