import { __awaiter } from 'tslib';
import { convertIntegrationFnToClass } from '@sentry/core';
import { logger } from '@sentry/utils';
import { BrowserWindow } from 'electron';
import { capturePage } from '../electron-normalize.js';

const INTEGRATION_NAME = 'Screenshots';
const screenshots = () => {
    return {
        name: INTEGRATION_NAME,
        processEvent(event, hint, client) {
            return __awaiter(this, void 0, void 0, function* () {
                const attachScreenshot = !!client.getOptions().attachScreenshot;
                if (!attachScreenshot) {
                    return event;
                }
                // We don't capture screenshots for transactions or native crashes
                if (!event.transaction && event.platform !== 'native') {
                    let count = 1;
                    for (const window of BrowserWindow.getAllWindows()) {
                        if (!hint.attachments) {
                            hint.attachments = [];
                        }
                        try {
                            if (!window.isDestroyed() && window.isVisible()) {
                                const filename = count === 1 ? 'screenshot.png' : `screenshot-${count}.png`;
                                const image = yield capturePage(window);
                                hint.attachments.push({ filename, data: image.toPNG(), contentType: 'image/png' });
                                count += 1;
                            }
                        }
                        catch (e) {
                            // Catch all errors so we don't break event submission if something goes wrong
                            logger.error('Error capturing screenshot', e);
                        }
                    }
                }
                return event;
            });
        },
    };
};
/** Adds Screenshots to events */
// eslint-disable-next-line deprecation/deprecation
const Screenshots = convertIntegrationFnToClass(INTEGRATION_NAME, screenshots);

export { Screenshots };
//# sourceMappingURL=screenshots.js.map
