import { Integrations } from '@sentry/node';
import { app } from 'electron';
import { ELECTRON_MAJOR_VERSION } from '../electron-normalize.js';

// We can't use the functional style of integration until they are exported as functions...
/**
 * Starts a worker thread to detect App Not Responding (ANR) events
 */
class Anr extends Integrations.Anr {
    constructor(options = {}) {
        if (ELECTRON_MAJOR_VERSION < 22) {
            throw new Error('Main process ANR detection requires Electron v22+');
        }
        super(Object.assign(Object.assign({}, options), { staticTags: Object.assign({ 'event.environment': 'javascript', 'event.origin': 'electron', 'event.process': 'browser' }, options.staticTags), appRootPath: app.getAppPath() }));
    }
}

export { Anr };
//# sourceMappingURL=anr.js.map
