import { ElectronOptions } from './';
import { AdditionalContext, ChildProcess, ElectronBreadcrumbs, ElectronMinidump, MainContext, MainProcessSession, OnUncaughtException, PreloadInjection, Screenshots, SentryMinidump } from './main/integrations';
import { EventToMain, ScopeToMain } from './renderer/integrations';
/** Convenience interface used to expose Integrations */
export interface Integrations {
    SentryMinidump: typeof SentryMinidump;
    ElectronMinidump: typeof ElectronMinidump;
    ElectronBreadcrumbs: typeof ElectronBreadcrumbs;
    MainContext: typeof MainContext;
    OnUncaughtExcept: typeof OnUncaughtException;
    PreloadInjection: typeof PreloadInjection;
    MainProcessSession: typeof MainProcessSession;
    AdditionalContext: typeof AdditionalContext;
    ChildProcess: typeof ChildProcess;
    Screenshots: typeof Screenshots;
    ScopeToMain: typeof ScopeToMain;
    EventToMain: EventToMain;
}
/** Return all Electron integrations and add EmptyIntegrations for integrations missing in this process. */
export declare function getIntegrations(): Integrations;
/** Filters out any EmptyIntegrations that are found */
export declare function removeEmptyIntegrations(options: Partial<ElectronOptions>): void;
//# sourceMappingURL=integrations.d.ts.map