/** An async mutex that queues up tasks for a shared resource */
export declare class Mutex {
    private readonly _entries;
    private _waiters;
    private _value;
    constructor();
    /** Run a task when all pending tasks are complete */
    runExclusive<T>(task: () => Promise<T> | T): Promise<T>;
    /** Gets a promise that resolves when all pending tasks are complete */
    private _acquire;
    /** Releases after a task is complete */
    private _release;
    /** Dispatches pending tasks */
    private _dispatch;
    /** Creates a new releaser */
    private _newReleaser;
    /** Drain unlock waiters */
    private _drainUnlockWaiters;
}
//# sourceMappingURL=mutex.d.ts.map