/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   paper-icon-button.js
 */

import {PaperInkyFocusBehavior} from '@polymer/paper-behaviors/paper-inky-focus-behavior.js';

import {Polymer} from '@polymer/polymer/lib/legacy/polymer-fn.js';

import {html} from '@polymer/polymer/lib/utils/html-tag.js';

import {LegacyElementMixin} from '@polymer/polymer/lib/legacy/legacy-element-mixin.js';

/**
 * Material design: [Icon
 * toggles](https://www.google.com/design/spec/components/buttons.html#buttons-toggle-buttons)
 *
 * `paper-icon-button` is a button with an image placed at the center. When the
 * user touches the button, a ripple effect emanates from the center of the button.
 *
 * `paper-icon-button` does not include a default icon set. To use icons from the
 * default set, include `PolymerElements/iron-icons/iron-icons.html`, and use the
 * `icon` attribute to specify which icon from the icon set to use.
 *
 *     <paper-icon-button icon="menu"></paper-icon-button>
 *
 * See [`iron-iconset`](iron-iconset) for more information about
 * how to use a custom icon set.
 *
 * Example:
 *
 *     <script type="module">
 *       import '@polymer/iron-icons/iron-icons.js';
 *     </script>
 *
 *     <paper-icon-button icon="favorite"></paper-icon-button>
 *     <paper-icon-button src="star.png"></paper-icon-button>
 *
 * To use `paper-icon-button` as a link, wrap it in an anchor tag. Since
 * `paper-icon-button` will already receive focus, you may want to prevent the
 * anchor tag from receiving focus as well by setting its tabindex to -1.
 *
 *     <a href="https://www.polymer-project.org" tabindex="-1">
 *       <paper-icon-button icon="polymer"></paper-icon-button>
 *     </a>
 *
 * ### Styling
 *
 * Style the button with CSS as you would a normal DOM element. If you are using
 * the icons provided by `iron-icons`, they will inherit the foreground color of
 * the button.
 *
 *     /* make a red "favorite" button *\/
 *     <paper-icon-button icon="favorite" style="color: red;"></paper-icon-button>
 *
 * By default, the ripple is the same color as the foreground at 25% opacity. You
 * may customize the color using the `--paper-icon-button-ink-color` custom
 * property.
 *
 * The following custom properties and mixins are available for styling:
 *
 * Custom property | Description | Default
 * ----------------|-------------|----------
 * `--paper-icon-button-disabled-text` | The color of the disabled button | `--disabled-text-color`
 * `--paper-icon-button-ink-color` | Selected/focus ripple color | `--primary-text-color`
 * `--paper-icon-button` | Mixin for a button | `{}`
 * `--paper-icon-button-disabled` | Mixin for a disabled button | `{}`
 * `--paper-icon-button-hover` | Mixin for button on hover | `{}`
 */
interface PaperIconButtonElement extends PaperInkyFocusBehavior, LegacyElementMixin, HTMLElement {

  /**
   * The URL of an image for the icon. If the src property is specified,
   * the icon property should not be.
   */
  src: string|null|undefined;

  /**
   * Specifies the icon name or index in the set of icons available in
   * the icon's icon set. If the icon property is specified,
   * the src property should not be.
   */
  icon: string|null|undefined;

  /**
   * Specifies the alternate text for the button, for accessibility.
   */
  alt: string|null|undefined;
  hostAttributes: object|null;
  registered(): void;
  _altChanged(newValue: any, oldValue: any): void;
}

export {PaperIconButtonElement};

declare global {

  interface HTMLElementTagNameMap {
    "paper-icon-button": PaperIconButtonElement;
  }
}
