/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import '@polymer/polymer/polymer-legacy.js';

import {Polymer} from '@polymer/polymer/lib/legacy/polymer-fn.js';
import {html} from '@polymer/polymer/lib/utils/html-tag.js';

import {PaperCheckedElementBehavior} from '../paper-checked-element-behavior.js';
import {PaperInkyFocusBehaviorImpl} from '../paper-inky-focus-behavior.js';

Polymer({
  _template: html`
    <style>
      :host {
        display: inline-block;
        white-space: nowrap;
      }

      :host(:focus) {
        outline: none
      }

      #radioContainer {
        display: inline-block;
        position: relative;
        width: 16px;
        height: 16px;
        cursor: pointer;
        vertical-align: middle;
      }

      #offRadio {
        position: absolute;
        top: 0px;
        left: 0px;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        border: solid 2px;
        border-color: black;
        transition: border-color 0.28s;
      }

      #onRadio {
        position: absolute;
        top: 4px;
        left: 4px;
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background-color: red;
        -webkit-transform: scale(0);
        transform: scale(0);
        transition: -webkit-transform ease 0.28s;
        transition: transform ease 0.28s;
      }

      :host([disabled]) {
        opacity: 0.3;
        pointer-events: none;
      }

      :host([pressed]) #offRadio,
      :host([active]) #offRadio {
        border-color: red;
      }

      :host([pressed]) #onRadio,
      :host([active]) #onRadio {
        -webkit-transform: scale(1);
        transform: scale(1);
      }

      #ink {
        position: absolute;
        top: -16px;
        left: -16px;
        width: 48px;
        height: 48px;
      }
    </style>

    <div id="radioContainer">
      <div id="offRadio"></div>
      <div id="onRadio"></div>
    </div>
`,

  is: 'paper-radio-button',
  behaviors: [PaperCheckedElementBehavior],
  hostAttributes: {role: 'radio'},

  ready: function() {
    this.toggles = true;
  },

  _createRipple: function() {
    this._rippleContainer = this.$.radioContainer;
    return PaperInkyFocusBehaviorImpl._createRipple.call(this);
  }
});
