/**
 * Wraps the template inside a scopedElements component
 *
 * @param {import('./renderable').LitHTMLRenderable} template
 * @param {ScopedElementsMap} scopedElements
 * @return {HTMLElement}
 */
export function getScopedElementsTemplate(template: import('./renderable').LitHTMLRenderable, scopedElements: ScopedElementsMap): HTMLElement;
export type ScopedElementsMap = {
    [key: string]: {
        new (): HTMLElement;
        prototype: HTMLElement;
    };
};
export type TemplateResult = {
    _$litType$: 1 | 2;
    strings: TemplateStringsArray;
    values: unknown[];
};
export type ScopedElementsTemplateGetter = typeof getScopedElementsTemplate;
//# sourceMappingURL=scopedElementsWrapper.d.ts.map