/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @fileoverview A convenience bundle import that includes common components.
 *
 * WARNING: This import is intended for prototyping and development builds only.
 * It is smaller than `@material/web/all.js` and includes the most common
 * components for starting a project. Import only the individual components used
 * for production.
 */
// LINT.IfChange(imports)
// go/keep-sorted start
import './button/filled-button.js';
import './button/outlined-button.js';
import './button/text-button.js';
import './checkbox/checkbox.js';
import './chips/assist-chip.js';
import './chips/chip-set.js';
import './chips/filter-chip.js';
import './dialog/dialog.js';
import './icon/icon.js';
import './iconbutton/icon-button.js';
import './list/list.js';
import './list/list-item.js';
import './menu/menu.js';
import './menu/menu-item.js';
import './menu/sub-menu.js';
import './progress/circular-progress.js';
import './progress/linear-progress.js';
import './radio/radio.js';
import './select/outlined-select.js';
import './select/select-option.js';
import './tabs/primary-tab.js';
import './tabs/tabs.js';
import './textfield/outlined-text-field.js';
// go/keep-sorted end
// LINT.ThenChange(:exports)
// LINT.IfChange(exports)
// go/keep-sorted start
export * from './button/filled-button.js';
export * from './button/outlined-button.js';
export * from './button/text-button.js';
export * from './checkbox/checkbox.js';
export * from './chips/assist-chip.js';
export * from './chips/chip-set.js';
export * from './chips/filter-chip.js';
export * from './dialog/dialog.js';
export * from './icon/icon.js';
export * from './iconbutton/icon-button.js';
export * from './list/list.js';
export * from './list/list-item.js';
export * from './menu/menu.js';
export * from './menu/menu-item.js';
export * from './menu/sub-menu.js';
export * from './progress/circular-progress.js';
export * from './progress/linear-progress.js';
export * from './radio/radio.js';
export * from './select/outlined-select.js';
export * from './select/select-option.js';
export * from './tabs/primary-tab.js';
export * from './tabs/tabs.js';
export * from './textfield/outlined-text-field.js';
// go/keep-sorted end
// LINT.ThenChange(:imports)
//# sourceMappingURL=common.js.map