import { TransformOptions } from '@babel/core';
import { Options } from '@rollup/plugin-node-resolve';
import { UserAgentCompat } from './user-agent-compat';
export interface CompatibilityTransformConfig {
    rootDir: string;
    readUserBabelConfig: boolean;
    nodeResolve: boolean | Options;
    compatibilityMode: string;
    customBabelConfig?: TransformOptions;
    fileExtensions: string[];
    babelExclude: string[];
    babelModernExclude: string[];
    babelModuleExclude: string[];
    customBabelInclude: string[];
    customBabelExclude: string[];
}
export interface FileData {
    uaCompat: UserAgentCompat;
    filePath: string;
    code: string;
    transformModule: boolean;
}
export declare type TransformJs = (file: FileData) => Promise<string>;
export declare function createCompatibilityTransform(cfg: CompatibilityTransformConfig): TransformJs;
