"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.polyfillModulesTransform = exports.createMaxCompatibilityBabelTransform = exports.createMinCompatibilityBabelTransform = exports.createCompatibilityBabelTransform = exports.createBabelTransform = exports.defaultConfig = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@babel/core");
const deepmerge_1 = tslib_1.__importDefault(require("deepmerge"));
exports.defaultConfig = {
    caller: {
        name: 'es-dev-server',
        supportsStaticESM: true,
    },
    /**
     * Enable syntax plugins for stage 3 features. This does **not** transform them,
     * it only ensures that babel does not crash when you're using them.
     */
    plugins: [
        require.resolve('@babel/plugin-syntax-dynamic-import'),
        require.resolve('@babel/plugin-syntax-import-meta'),
        require.resolve('@babel/plugin-syntax-class-properties'),
        require.resolve('@babel/plugin-syntax-numeric-separator'),
    ],
    sourceType: 'module',
};
/**
 * Creates a babel compiler backed by an in-memory last-read-out cache. Sets up configuration
 * based on a number of presets.
 */
function createBabelTransform(cfg, baseConfig) {
    var _a;
    const config = deepmerge_1.default.all([
        exports.defaultConfig,
        baseConfig !== null && baseConfig !== void 0 ? baseConfig : {},
        {
            babelrc: !!cfg.readUserBabelConfig,
            // undefined is default behavior
            configFile: cfg.readUserBabelConfig ? undefined : false,
        },
        (_a = cfg.customBabelConfig) !== null && _a !== void 0 ? _a : {},
    ]);
    return async function transform(filename, source) {
        const largeFile = source.length > 100000;
        const result = await core_1.transformAsync(source, {
            filename,
            // prevent generating pretty output for large files
            compact: largeFile,
            // babel runs out of memory when processing source maps andfor large files
            sourceMaps: !largeFile,
            ...config,
        });
        if (!result || typeof result.code !== 'string') {
            throw new Error('Failed to transform');
        }
        return result.code;
    };
}
exports.createBabelTransform = createBabelTransform;
function createCompatibilityBabelTransform(cfg) {
    return createBabelTransform(cfg, {
        presets: [
            [
                require.resolve('@babel/preset-env'),
                {
                    targets: Array.isArray(cfg.browserTarget) ? cfg.browserTarget : [cfg.browserTarget],
                    exclude: [
                        // included below in loose mode
                        '@babel/plugin-proposal-optional-chaining',
                        '@babel/plugin-proposal-nullish-coalescing-operator',
                    ],
                    useBuiltIns: false,
                    shippedProposals: true,
                    modules: false,
                    bugfixes: true,
                },
            ],
        ],
        plugins: [
            // loose mode saves a lot of extra generated code
            [require.resolve('@babel/plugin-proposal-optional-chaining'), { loose: true }],
            [require.resolve('@babel/plugin-proposal-nullish-coalescing-operator'), { loose: true }],
        ],
    });
}
exports.createCompatibilityBabelTransform = createCompatibilityBabelTransform;
function createMinCompatibilityBabelTransform(cfg) {
    return createCompatibilityBabelTransform({
        ...cfg,
        browserTarget: [
            'last 2 Chrome major versions',
            'last 2 ChromeAndroid major versions',
            'last 2 Firefox major versions',
            'last 2 Edge major versions',
            'last 2 Safari major versions',
            'last 2 iOS major versions',
        ],
    });
}
exports.createMinCompatibilityBabelTransform = createMinCompatibilityBabelTransform;
function createMaxCompatibilityBabelTransform(cfg) {
    return createCompatibilityBabelTransform({
        ...cfg,
        browserTarget: ['defaults', 'ie 10'],
    });
}
exports.createMaxCompatibilityBabelTransform = createMaxCompatibilityBabelTransform;
/**
 * transform for only polyfilling modules, this should be run after the compatibility
 * config where all js is already compiled to a compatible format. we therefore don't
 * include any extra plugins or user configuration
 */
exports.polyfillModulesTransform = createBabelTransform({}, {
    plugins: [
        require.resolve('@babel/plugin-proposal-dynamic-import'),
        require.resolve('@babel/plugin-transform-modules-systemjs'),
        // systemjs adds template literals, we do systemjs after (potential)
        // es5 compilation so we need to ensure it stays es5
        require.resolve('@babel/plugin-transform-template-literals'),
    ],
    babelrc: false,
    configFile: false,
});
//# sourceMappingURL=babel-transform.js.map