/// <reference types="node" />
import { FSWatcher } from 'chokidar';
import Koa, { Context } from 'koa';
import { Server } from 'net';
import { ParsedConfig } from './config';
import { MessageChannel } from './utils/MessageChannel';
declare type ServeResult = undefined | null | {
    body: string;
    type?: string;
    headers?: Record<string, string>;
};
declare type TransformResult = undefined | null | {
    body?: string;
    headers?: Record<string, string>;
    transformCache?: boolean;
};
declare type ResolveResult = undefined | null | string;
declare type ResolveMimeTypeResult = undefined | null | string;
interface ServerArgs {
    config: ParsedConfig;
    app: Koa;
    server: Server;
    fileWatcher: FSWatcher;
    messageChannel?: MessageChannel;
}
export interface Plugin {
    serverStart?(args: ServerArgs): void | Promise<void>;
    serve?(context: Context): ServeResult | Promise<ServeResult>;
    transform?(context: Context): TransformResult | Promise<TransformResult>;
    resolveImport?(args: {
        source: string;
        context: Context;
    }): ResolveResult | Promise<ResolveResult>;
    resolveMimeType?(context: Context): ResolveMimeTypeResult | Promise<ResolveMimeTypeResult>;
}
export {};
