export declare const WINDOW: import("@sentry/utils").InternalGlobal & Window;
export declare const REPLAY_SESSION_KEY = "sentryReplaySession";
export declare const REPLAY_EVENT_NAME = "replay_event";
export declare const RECORDING_EVENT_NAME = "replay_recording";
export declare const UNABLE_TO_SEND_REPLAY = "Unable to send Replay";
export declare const SESSION_IDLE_PAUSE_DURATION = 300000;
export declare const SESSION_IDLE_EXPIRE_DURATION = 900000;
/** Default flush delays */
export declare const DEFAULT_FLUSH_MIN_DELAY = 5000;
export declare const DEFAULT_FLUSH_MAX_DELAY = 5500;
export declare const BUFFER_CHECKOUT_TIME = 60000;
export declare const RETRY_BASE_INTERVAL = 5000;
export declare const RETRY_MAX_COUNT = 3;
export declare const NETWORK_BODY_MAX_SIZE = 150000;
export declare const CONSOLE_ARG_MAX_SIZE = 5000;
export declare const SLOW_CLICK_THRESHOLD = 3000;
export declare const SLOW_CLICK_SCROLL_TIMEOUT = 300;
/** When encountering a total segment size exceeding this size, stop the replay (as we cannot properly ingest it). */
export declare const REPLAY_MAX_EVENT_BUFFER_SIZE = 20000000;
/** Replays must be min. 5s long before we send them. */
export declare const MIN_REPLAY_DURATION = 4999;
export declare const MIN_REPLAY_DURATION_LIMIT = 15000;
/** The max. length of a replay. */
export declare const MAX_REPLAY_DURATION = 3600000;
/** Default attributes to be ignored when `maskAllText` is enabled */
export declare const DEFAULT_IGNORED_ATTRIBUTES: string[];
export declare const CANVAS_QUALITY: {
    low: {
        sampling: {
            canvas: number;
        };
        dataURLOptions: {
            type: string;
            quality: number;
        };
    };
    medium: {
        sampling: {
            canvas: number;
        };
        dataURLOptions: {
            type: string;
            quality: number;
        };
    };
    high: {
        sampling: {
            canvas: number;
        };
        dataURLOptions: {
            type: string;
            quality: number;
        };
    };
};
//# sourceMappingURL=constants.d.ts.map
