const browser = require('@sentry/browser');
const index = require('./integrations/index.js');
const core = require('@sentry/core');
const metricsAggregator = require('./integrations/metrics-aggregator.js');
const sdk = require('./sdk.js');

const metrics = Object.assign(Object.assign({}, core.metrics), { 
    // Override the default browser metrics aggregator with the Electron renderer one
    MetricsAggregator: metricsAggregator.MetricsAggregator });
const Integrations = Object.assign(Object.assign({}, browser.Integrations), index);

exports.BrowserClient = browser.BrowserClient;
exports.BrowserProfilingIntegration = browser.BrowserProfilingIntegration;
exports.BrowserTracing = browser.BrowserTracing;
exports.Replay = browser.Replay;
exports.addTracingExtensions = browser.addTracingExtensions;
exports.lastEventId = browser.lastEventId;
exports.showReportDialog = browser.showReportDialog;
exports.Hub = core.Hub;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addEventProcessor = core.addEventProcessor;
exports.addGlobalEventProcessor = core.addGlobalEventProcessor;
exports.addIntegration = core.addIntegration;
exports.captureCheckIn = core.captureCheckIn;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureMessage = core.captureMessage;
exports.configureScope = core.configureScope;
exports.continueTrace = core.continueTrace;
exports.createTransport = core.createTransport;
exports.extractTraceparentData = core.extractTraceparentData;
exports.getActiveSpan = core.getActiveSpan;
exports.getActiveTransaction = core.getActiveTransaction;
exports.getClient = core.getClient;
exports.getCurrentHub = core.getCurrentHub;
exports.getCurrentScope = core.getCurrentScope;
exports.getGlobalScope = core.getGlobalScope;
exports.getHubFromCarrier = core.getHubFromCarrier;
exports.getIsolationScope = core.getIsolationScope;
exports.makeMain = core.makeMain;
exports.runWithAsyncContext = core.runWithAsyncContext;
exports.setContext = core.setContext;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setMeasurement = core.setMeasurement;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.spanStatusfromHttpCode = core.spanStatusfromHttpCode;
exports.startActiveSpan = core.startActiveSpan;
exports.startInactiveSpan = core.startInactiveSpan;
exports.startSpan = core.startSpan;
exports.startSpanManual = core.startSpanManual;
exports.startTransaction = core.startTransaction;
exports.trace = core.trace;
exports.withMonitor = core.withMonitor;
exports.withScope = core.withScope;
exports.defaultIntegrations = sdk.defaultIntegrations;
exports.init = sdk.init;
exports.Integrations = Integrations;
exports.metrics = metrics;
//# sourceMappingURL=index.js.map
