const ipc = require('./ipc.js');

/**
 * Enables the sending of ANR messages to the main process.
 */
function enableAnrRendererMessages(options) {
    const config = Object.assign({ pollInterval: 1000, anrThreshold: 5000, captureStackTrace: false }, options);
    const ipc$1 = ipc.getIPC();
    document.addEventListener('visibilitychange', () => {
        ipc$1.sendStatus({ status: document.visibilityState, config });
    });
    ipc$1.sendStatus({ status: document.visibilityState, config });
    setInterval(() => {
        ipc$1.sendStatus({ status: 'alive', config });
    }, config.pollInterval);
}

exports.enableAnrRendererMessages = enableAnrRendererMessages;
//# sourceMappingURL=anr.js.map
