import { Envelope, Event, Profile } from '@sentry/types';
/**
 * Normalizes all URLs in an event. See {@link normalizeUrl} for more
 * information. Mutates the passed in event.
 *
 * @param event The event to normalize.
 */
export declare function normalizeEvent(event: Event, basePath: string): Event;
/** Normalizes URLs in any replay_event items found in an envelope */
export declare function normalizeUrlsInReplayEnvelope(envelope: Envelope, basePath: string): Envelope;
/**
 * Normalizes all URLs in a profile
 */
export declare function normaliseProfile(profile: Profile, basePath: string): void;
//# sourceMappingURL=normalize.d.ts.map