import { Client, EventProcessor, Hub, Integration, IntegrationFn, Options } from '@sentry/types';
declare module '@sentry/types' {
    interface Integration {
        isDefaultInstance?: boolean;
    }
}
export declare const installedIntegrations: string[];
/** Map of integrations assigned to a client */
export type IntegrationIndex = {
    [key: string]: Integration;
};
/** Gets integrations to install */
export declare function getIntegrationsToSetup(options: Pick<Options, 'defaultIntegrations' | 'integrations'>): Integration[];
/**
 * Given a list of integration instances this installs them all. When `withDefaults` is set to `true` then all default
 * integrations are added unless they were already provided before.
 * @param integrations array of integration instances
 * @param withDefault should enable default integrations
 */
export declare function setupIntegrations(client: Client, integrations: Integration[]): IntegrationIndex;
/** Setup a single integration.  */
export declare function setupIntegration(client: Client, integration: Integration, integrationIndex: IntegrationIndex): void;
/** Add an integration to the current hub's client. */
export declare function addIntegration(integration: Integration): void;
/**
 * Convert a new integration function to the legacy class syntax.
 * In v8, we can remove this and instead export the integration functions directly.
 *
 * @deprecated This will be removed in v8!
 */
export declare function convertIntegrationFnToClass<Fn extends IntegrationFn>(name: string, fn: Fn): Integration & {
    id: string;
    new (...args: Parameters<Fn>): Integration & ReturnType<Fn> & {
        setupOnce: (addGlobalEventProcessor?: (callback: EventProcessor) => void, getCurrentHub?: () => Hub) => void;
    };
};
//# sourceMappingURL=integration.d.ts.map
