# Android Development Instructions

This document describes how to develop and debug for Android.

The main entrypoint to Android's Java code is `client/src/cordova/plugin/android/java/org/outline/OutlinePlugin.java`

## Set up your environment

Additional requirements for Android:

- [Java Development Kit (JDK) 11](https://jdk.java.net/archive/)
  - Set `JAVA_HOME` environment variable if you have multiple JDK versions installed. On macOS: `export JAVA_HOME=$(/usr/libexec/java_home -v 11.0)`.
- Latest [Android Sdk Commandline Tools](https://developer.android.com/studio/command-line) ([download](https://developer.android.com/studio#command-line-tools-only))
  - Place it at `$HOME/Android/sdk/cmdline-tools/latest`
  - Set `ANDROID_HOME` (e.g., `$HOME/Android/sdk`) and `ANDROID_NDK` (e.g., `$ANDROID_HOME/ndk`) environment variables
- Android SDK 34 (with build-tools) via commandline `$HOME/Android/sdk/cmdline-tools/latest/bin/sdkmanager "platforms;android-34" "build-tools;34.0.0"`
- [Gradle 7.3+](https://gradle.org/install/). On macOS: `brew install gradle`.

[Android Studio 2020.3.1+](https://developer.android.com/studio) is not required, but it's helpful if you are developing Android code.

You can check your environment with:

```sh
cd client
npx cordova requirements android
```

## Build the app

To build the app for Android, run:

```sh
  npm run action client/src/cordova/build android
```

The built apk will be at: `client/platforms/android/app/build/outputs/apk/debug/app-debug.apk`.

We also support passing a `--verbose` option on cordova android:

```sh
  npm run action client/src/cordova/build android -- --verbose
```

Make sure to rebuild after modifying platform dependent files!

> 💡 NOTE: If this command ever gives you unexpected Cordova errors, try runnning `npm run reset` first.

## Run the app

1. Start the simulator or connect an Android device and enable [USB debugging](https://developer.android.com/studio/debug/dev-options.html#enable).
1. From the project root, run: `adb install -r -d client/platforms/android/app/build/outputs/apk/debug/app-debug.apk`

## Develop code

Open `src/cordova/android/OutlineAndroidLib` on Android Studio. That will allow you to leverage the IDE features (auto-complete, warnings, etc) and run unit tests easily.

This project represents a library that implements most of the Outline native functionality and does not depend on Cordova. That library is imported by the "app" module that is generated by Cordova. The only native Android code outside of this library is `OutlinePlugin.java`, which integrates with CordovaLib.

### To debug the web app

Run Outline on your phone with [USB debugging enabled](https://developer.android.com/studio/debug/dev-options.html#enable), then on Chrome:

- Go to [chrome://inspect](chrome://inspect)
- Find Outline
- Click inspect
- Open the Console
- Note that all TypeScript code is browserified in a single main.cordova.js

### To debug Java code

You can debug the Java code using [logcat on Android Studio](https://developer.android.com/studio/debug/logcat):

1. Start the app
1. Select the "Logcat" tab at the bottom
1. Select `org.outline.android.client` in the middle menu (it should not say "no debuggable processes")

It's also possible to use the [`logcat` command](https://developer.android.com/tools/logcat).
