import { FSWatcher } from 'chokidar';
import { Middleware } from 'koa';
import { Plugin } from '../Plugin';
import { MessageChannel } from '../utils/MessageChannel';
export declare class TransformSyntaxError extends Error {
}
export interface PluginServeMiddlewareConfig {
    plugins: Plugin[];
    fileWatcher: FSWatcher;
    logErrorsToBrowser: boolean;
    messageChannel?: MessageChannel;
    rootDir: string;
    fileExtensions: string[];
}
/**
 * Sets up a middleware which allows plugins to transform files before they are served to the browser.
 */
export declare function createPluginTransformMiddlware(cfg: PluginServeMiddlewareConfig): Middleware;
