"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createHistoryAPIFallbackMiddleware = void 0;
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
/**
 * Serves index.html when a non-file request within the scope of the app index is made.
 * This allows SPA routing.
 */
function createHistoryAPIFallbackMiddleware(cfg) {
    return function historyAPIFallback(ctx, next) {
        if (ctx.method !== 'GET' || path_1.default.extname(ctx.path)) {
            // not a GET, or a direct file request
            return next();
        }
        if (!ctx.headers || typeof ctx.headers.accept !== 'string') {
            return next();
        }
        if (ctx.headers.accept.includes('application/json')) {
            return next();
        }
        if (!(ctx.headers.accept.includes('text/html') || ctx.headers.accept.includes('*/*'))) {
            return next();
        }
        if (!ctx.url.startsWith(cfg.appIndexDir)) {
            return next();
        }
        // rewrite url and let static serve take it further
        ctx.url = cfg.appIndex;
        return next();
    };
}
exports.createHistoryAPIFallbackMiddleware = createHistoryAPIFallbackMiddleware;
//# sourceMappingURL=history-api-fallback.js.map