import { convertIntegrationFnToClass, getCurrentScope } from '@sentry/core';
import { normalize } from '@sentry/utils';
import { getIPC } from '../ipc.js';

const INTEGRATION_NAME = 'ScopeToMain';
const scopeToMain = () => {
    return {
        name: INTEGRATION_NAME,
        setup() {
            const scope = getCurrentScope();
            if (scope) {
                const ipc = getIPC();
                scope.addScopeListener((updatedScope) => {
                    ipc.sendScope(JSON.stringify(normalize(updatedScope.getScopeData(), 20, 2000)));
                    scope.clearBreadcrumbs();
                    scope.clearAttachments();
                });
            }
        },
    };
};
/**
 * Passes scope changes to the main process.
 */
// eslint-disable-next-line deprecation/deprecation
const ScopeToMain = convertIntegrationFnToClass(INTEGRATION_NAME, scopeToMain);

export { ScopeToMain };
//# sourceMappingURL=scope-to-main.js.map
