/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { TextAreaCharCounter, TextFieldBase, TextFieldInputMode, TextFieldType } from '@material/mwc-textfield/mwc-textfield-base.js';
import { TemplateResult } from 'lit';
export { TextAreaCharCounter, TextFieldInputMode, TextFieldType };
/** @soyCompatible */
export declare abstract class TextAreaBase extends TextFieldBase {
    protected formElement: HTMLInputElement;
    rows: number;
    cols: number;
    charCounter: boolean | TextAreaCharCounter;
    /** @soyTemplate */
    render(): TemplateResult;
    /** @soyTemplate */
    protected renderInput(): TemplateResult;
}
