#!/bin/bash
DOCS_ROOT=dist/docs/
REPO_NAME="ooni/probe-multiplatform"
MAIN_BRANCH="main"
COMMIT_HASH=$(git rev-parse --short HEAD)

mkdir -p $DOCS_ROOT

strip_title() {
    # Since the title is already present in the frontmatter, we need to remove
    # it to avoid duplicate titles
    local infile="$1"
    cat $infile | awk 'BEGIN{p=1} /^#/{if(p){p=0; next}} {print}'
}

generate_doc() {
    local order="$1"
    local slug="$2"
    local input_file="$3"
    local output_file="$4"
    local title="$5"
    local description="$6"

    cat <<EOF>"$DOCS_ROOT/$output_file"
---
# Do not edit! This file is automatically generated
# version: $REPO_NAME/$input_file:$COMMIT_HASH
title: $title
description: $description
slug: $slug
sidebar:
    order: $order
---
EOF
    echo "[edit file](https://github.com/$REPO_NAME/edit/$MAIN_BRANCH/$input_file)" >> "$DOCS_ROOT/$output_file"
    strip_title "$input_file" >> "$DOCS_ROOT/$output_file"
}

# Generate documentation files
generate_doc 0 "probe-multiplatform" "README.md" "00-index.md" "OONI Probe" "OONI Probe documentation"
generate_doc 1 "probe-multiplatform/architecture" "docs/Architecture.md" "01-architecture.md" "Architecture" "Architecture documentation"
generate_doc 2 "probe-multiplatform/database" "docs/Database.md" "02-database.md" "Database" "Database documentation"
generate_doc 3 "probe-multiplatform/background-work" "docs/BackgroundWork.md" "03-background-work.md" "Background Work" "Background Work documentation"
generate_doc 4 "probe-multiplatform/release" "docs/Release.md" "04-release.md" "Release Process" "App distribution documentation"
generate_doc 4 "probe-multiplatform/api-usage" "docs/ApiUsage.md" "05-api-usage.md" "API Usage" "Back-end usage documentation"
