package org.ooni.probe.ui.settings.webcategories

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.asPaddingValues
import androidx.compose.foundation.layout.navigationBars
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.foundation.lazy.rememberLazyListState
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.sp
import ooniprobe.composeapp.generated.resources.Res
import ooniprobe.composeapp.generated.resources.Settings_Websites_Categories_Label
import ooniprobe.composeapp.generated.resources.Settings_Websites_Categories_Selection_All
import ooniprobe.composeapp.generated.resources.Settings_Websites_Categories_Selection_None
import ooniprobe.composeapp.generated.resources.ic_deselect
import ooniprobe.composeapp.generated.resources.ic_select_all
import org.jetbrains.compose.resources.painterResource
import org.jetbrains.compose.resources.stringResource
import org.ooni.probe.ui.settings.category.SwitchSettingsView
import org.ooni.probe.ui.shared.NavigationBackButton
import org.ooni.probe.ui.shared.TopBar
import org.ooni.probe.ui.shared.VerticalScrollbar

@Composable
fun WebCategoriesScreen(
    state: WebCategoriesViewModel.State,
    onEvent: (WebCategoriesViewModel.Event) -> Unit,
) {
    Column(Modifier.background(MaterialTheme.colorScheme.background)) {
        TopBar(
            title = {
                Text(
                    stringResource(Res.string.Settings_Websites_Categories_Label),
                    style = MaterialTheme.typography.headlineSmall.copy(fontSize = 18.sp),
                    maxLines = 1,
                    overflow = TextOverflow.Ellipsis,
                )
            },
            navigationIcon = {
                NavigationBackButton({ onEvent(WebCategoriesViewModel.Event.BackClicked) })
            },
            actions = {
                IconButton(
                    onClick = { onEvent(WebCategoriesViewModel.Event.SelectAllClicked) },
                    enabled = state.selectAllEnabled,
                ) {
                    Icon(
                        painterResource(Res.drawable.ic_select_all),
                        stringResource(Res.string.Settings_Websites_Categories_Selection_All),
                    )
                }
                IconButton(
                    onClick = { onEvent(WebCategoriesViewModel.Event.DeselectAllClicked) },
                    enabled = state.deselectAllEnabled,
                ) {
                    Icon(
                        painterResource(Res.drawable.ic_deselect),
                        stringResource(Res.string.Settings_Websites_Categories_Selection_None),
                    )
                }
            },
        )

        Box {
            val lazyListState = rememberLazyListState()
            LazyColumn(
                contentPadding = WindowInsets.navigationBars.asPaddingValues(),
                state = lazyListState,
            ) {
                items(state.items, key = { it.item.settingsKey!! }) { item ->
                    SwitchSettingsView(
                        icon = item.item.icon,
                        title = item.item.title,
                        key = item.item.settingsKey!!,
                        checked = item.isSelected,
                        enabled = true,
                        supportingContent = { Text(stringResource(item.item.description)) },
                        onCheckedChange = { _, value ->
                            onEvent(WebCategoriesViewModel.Event.PreferenceChanged(item.item, value))
                        },
                    )
                }
            }
            VerticalScrollbar(
                state = lazyListState,
                modifier = Modifier.align(Alignment.CenterEnd),
            )
        }
    }
}
