package org.ojrandom.paiesque.rhr;

/**
 * Summary of RHR calculations for different time periods
 */
public class RHRSummary {
    public final int lastWeekRHR;
    public final int lastMonthRHR;
    public final int currentBaselineRHR;

    public RHRSummary(int lastWeekRHR, int lastMonthRHR, int currentBaselineRHR) {
        this.lastWeekRHR = lastWeekRHR;
        this.lastMonthRHR = lastMonthRHR;
        this.currentBaselineRHR = currentBaselineRHR;
    }

    public static RHRSummary empty() {
        return new RHRSummary(-1, -1, -1);
    }

    @Override
    public String toString() {
        return String.format("RHRSummary{week=%d, month=%d, baseline=%d}",
                lastWeekRHR, lastMonthRHR, currentBaselineRHR);
    }
}