package org.ojrandom.paiesque.rhr;

/**
 * Represents historical baseline for RHR calculations
 */
public class HistoricalBaseline {
    public final int median;
    public final int iqr;
    public final int minExpected;
    public final int maxExpected;
    public final int personalizedMin;
    public final int personalizedMax;

    public HistoricalBaseline(int median, int iqr, int minExpected, int maxExpected,
                              int personalizedMin, int personalizedMax) {
        this.median = median;
        this.iqr = iqr;
        this.minExpected = minExpected;
        this.maxExpected = maxExpected;
        this.personalizedMin = personalizedMin;
        this.personalizedMax = personalizedMax;
    }

    @Override
    public String toString() {
        return String.format("HistoricalBaseline{median=%d, iqr=%d, range=%d-%d, personalized=%d-%d}",
                median, iqr, minExpected, maxExpected, personalizedMin, personalizedMax);
    }
}