package org.ojrandom.paiesque.pai;

public class ZoneCalculator {
    private final int restingHR;
    private final int maxHR;
    private final int measuredMaxHR; // Always use measured data

    public ZoneCalculator(int restingHR, int maxHR, int measuredMaxHR) {
        this.restingHR = restingHR;
        this.maxHR = maxHR;
        this.measuredMaxHR = measuredMaxHR;
    }

    public static class ZoneRange {
        public final int minBPM;
        public final int maxBPM;
        public final String percentageRange;

        public ZoneRange(int minBPM, int maxBPM, String percentageRange) {
            this.minBPM = minBPM;
            this.maxBPM = maxBPM;
            this.percentageRange = percentageRange;
        }

        public String getDisplayText() {
            return minBPM + "-" + maxBPM;
        }

        public String getCompactDisplayText() {
            return minBPM + "-" + maxBPM;
        }
    }

    public ZoneRange getZone50_59() {
        return calculateZone(0.50, 0.59, "50-59%");
    }

    public ZoneRange getZone60_69() {
        return calculateZone(0.60, 0.69, "60-69%");
    }

    public ZoneRange getZone70_79() {
        return calculateZone(0.70, 0.79, "70-79%");
    }

    public ZoneRange getZone80_89() {
        return calculateZone(0.80, 0.89, "80-89%");
    }

    public ZoneRange getZone90_100() {
        // ALWAYS use measured max HR for the highest zone
        int minBPM = restingHR + (int)Math.round(0.90 * (maxHR - restingHR));
        return new ZoneRange(minBPM, measuredMaxHR, "90-100%");
    }

    private ZoneRange calculateZone(double minIntensity, double maxIntensity, String percentageLabel) {
        int minBPM = restingHR + (int)Math.round(minIntensity * (maxHR - restingHR));
        int maxBPM = restingHR + (int)Math.round(maxIntensity * (maxHR - restingHR));
        return new ZoneRange(minBPM, maxBPM, percentageLabel);
    }
}