package org.ojrandom.paiesque.io;

import android.content.Context;
import android.util.Log;

import org.ojrandom.paiesque.PaiesqueApplication;
import org.ojrandom.paiesque.data.AppConstants;
import org.ojrandom.paiesque.data.DataManager;
import org.ojrandom.paiesque.logging.AppLogger;

import java.io.File;

public class FileOperationsManager {
    private final Context context;
    private static final String TAG = "FileOperationsManager";

    public FileOperationsManager(Context context) {
        this.context = context;
    }

    public void deleteAllData() {
        AppLogger.d(TAG, "Starting delete all data operation");

        try {
            // 1. Get DataManager from Application and close database connections first
            PaiesqueApplication app = (PaiesqueApplication) context.getApplicationContext();
            DataManager dataManager = app.getDataManager();

            if (dataManager != null) {
                dataManager.closeDatabase();
            }

            // 2. Delete Gadgetbridge database file
            File gadgetbridgeFile = new File(context.getFilesDir(), AppConstants.KEY_DB_NAME);
            boolean gadgetbridgeDeleted = gadgetbridgeFile.delete();
            AppLogger.d(TAG, "Gadgetbridge database deletion: " + (gadgetbridgeDeleted ? "successful" : "failed"));

            // Also delete related Gadgetbridge files
            String[] suffixes = {"-journal", "-wal", "-shm"};
            for (String suffix : suffixes) {
                File relatedFile = new File(context.getFilesDir(), AppConstants.KEY_DB_NAME + suffix);
                if (relatedFile.exists()) {
                    boolean relatedDeleted = relatedFile.delete();
                    AppLogger.d(TAG, "Related file " + relatedFile.getName() + " deletion: " +
                            (relatedDeleted ? "successful" : "failed"));
                }
            }

            // 3. Clear settings - this will now handle readonly state properly
            clearAllPreferences();

            // 4. Reset the DataManager state
            if (dataManager != null) {
                dataManager.cleanupAfterDelete();
            }

            AppLogger.d(TAG, "All data deleted successfully");

        } catch (Exception e) {
            AppLogger.e(TAG, "Error during delete all data operation", e);
        }
    }

    private void clearAllPreferences() {
        try {
            PaiesqueApplication app = (PaiesqueApplication) context.getApplicationContext();
            DataManager dataManager = app.getDataManager();
            dataManager.getPaiesqueDBManager().clearAllSettings();

            AppLogger.d(TAG, "All database settings cleared successfully");
        } catch (Exception e) {
            AppLogger.e(TAG, "Error clearing database settings", e);
        }
    }

}