package org.ojrandom.paiesque.data.sync;

import android.database.Cursor;

import org.ojrandom.paiesque.data.GadgetbridgeSyncSource;

import java.util.Map;

/**
 * Interface for manufacturer-specific query handlers.
 */
public interface QueryHandler {
    /**
     * Builds a query for a single table (backward compatibility).
     */
    String buildQuery(String tableName, long lastSyncTimestamp);

    /**
     * Builds a query for multiple tables (new elegant approach).
     * For single-table manufacturers, implementers can call the single-table version.
     * For multi-table manufacturers (CMF, COLMI), implement JOIN logic here.
     */
    String buildQuery(String[] tableNames, long lastSyncTimestamp);

    /**
     * Extracts a heart rate record from the query result cursor.
     */
    HeartRateRecord extractRecord(Cursor cursor, String tableName,
                                  Map<String, Long> deviceMap, GadgetbridgeSyncSource sourceDbHelper);

    /**
     * Heart rate record data structure.
     */
    class HeartRateRecord {
        public final long timestamp;
        public final long deviceId;
        public final int heartRate;
        public final boolean isValid;

        private HeartRateRecord(long timestamp, long deviceId, int heartRate, boolean isValid) {
            this.timestamp = timestamp;
            this.deviceId = deviceId;
            this.heartRate = heartRate;
            this.isValid = isValid;
        }

        public static HeartRateRecord valid(long timestamp, long deviceId, int heartRate) {
            return new HeartRateRecord(timestamp, deviceId, heartRate, true);
        }

        public static HeartRateRecord invalid() {
            return new HeartRateRecord(0, 0, 0, false);
        }
    }
}