package org.ojrandom.paiesque.data.sync;

import android.database.Cursor;
import android.util.Log;

import org.ojrandom.paiesque.data.GadgetbridgeSyncSource;
import org.ojrandom.paiesque.logging.AppLogger;

import java.util.Map;

/**
 * Specialized query handler for Huawei devices.
 * Handles both standard activity samples and workout data with different schemas.
 */
public class HuaweiQueryHandler extends BaseQueryHandler {
    private static final String TABLE_HUAWEI_WORKOUT_DATA = "HUAWEI_WORKOUT_DATA_SAMPLE";

    @Override
    public String buildQuery(String tableName, long globalLastTimestamp) {
        // This handler is ONLY used for HUAWEI_WORKOUT_DATA_SAMPLE
        return "SELECT wd.TIMESTAMP, ws.DEVICE_ID, wd.HEART_RATE " +
                "FROM HUAWEI_WORKOUT_DATA_SAMPLE wd " +
                "INNER JOIN HUAWEI_WORKOUT_SUMMARY_SAMPLE ws ON wd.WORKOUT_ID = ws.WORKOUT_ID " +
                "WHERE wd.TIMESTAMP > ? " +
                "ORDER BY wd.TIMESTAMP";
    }

    @Override
    public HeartRateRecord extractRecord(Cursor cursor, String tableName,
                                         Map<String, Long> deviceMap,
                                         GadgetbridgeSyncSource syncSource) {
        try {
            long timestamp = cursor.getLong(0);
            String sourceDeviceId = String.valueOf(cursor.getLong(1));
            int heartRate = cursor.getInt(2);

            return createHeartRateRecord(timestamp, sourceDeviceId, heartRate, deviceMap, "HuaweiWorkout");
        } catch (Exception e) {
            AppLogger.e(TAG, "Error extracting Huawei workout record", e);
            return HeartRateRecord.invalid();
        }
    }
}