package org.ojrandom.paiesque.data.backup;

public class BackupData {
    public Metadata metadata;

    public static class Metadata {
        public String exportVersion = "1.0";
        public long exportTimestamp;
        public String appVersion;
        public String sourceDeviceModel;
        public String[] contents = {"DEVICES", "HEART_RATES"};

        public Metadata() {
            this.exportTimestamp = System.currentTimeMillis();
        }
    }

    public static class Device {
        public int id;
        public String name;
        public String manufacturer;
        public String identifier; // MAC address
        public String sourceDeviceId;
        public long createdAt;
    }

    public static class HeartRate {
        public long timestamp;
        public int deviceId;
        public int heartRate;
        public int localDate;
        public int minuteOfDay;
        public long syncedAt;
    }
}