// PaiesqueApplication.java
package org.ojrandom.paiesque;

import android.app.Application;
import android.content.SharedPreferences;
import android.util.Log;

import org.ojrandom.paiesque.data.DataManager;
import org.ojrandom.paiesque.logging.AppLogger;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PaiesqueApplication extends Application {
    private static final String TAG = "PaiesqueApplication";
    private static PaiesqueApplication instance;
    private DataManager dataManager;
    private ExecutorService backgroundExecutor;

    @Override
    public void onCreate() {
        super.onCreate();

        AppLogger.initialize(this);

        instance = this;
        backgroundExecutor = Executors.newFixedThreadPool(3);
        dataManager = DataManager.getInstance(this);

        // This will only log if level is DEBUG or lower
        AppLogger.d(TAG, "PaiesqueApplication initialized");
    }

    public static PaiesqueApplication getInstance() {
        return instance;
    }

    public DataManager getDataManager() {
        return dataManager;
    }

    public ExecutorService getBackgroundExecutor() {
        return backgroundExecutor;
    }

    @Override
    public void onTerminate() {
        super.onTerminate();
        if (dataManager != null) {
            dataManager.cleanup();
        }
        if (backgroundExecutor != null && !backgroundExecutor.isShutdown()) {
            backgroundExecutor.shutdown();
        }
        AppLogger.d(TAG, "PaiesqueApplication terminated");
    }
}