plugins {
    id("com.android.application")
}

android {
    namespace = "org.ojrandom.paiesque"
    compileSdk = 34

    buildFeatures {
        buildConfig = true
    }

    // F-Droid's official solution
    dependenciesInfo {
        includeInApk = false
        includeInBundle = false
    }

    defaultConfig {
        applicationId = "org.ojrandom.paiesque"
        minSdk = 26
        targetSdk = 34
        versionCode = 34
        versionName = "34"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    // Only configure signing if we're NOT in F-Droid build environment
    if (System.getenv("FDROID") != "true") {
                // Fix: Enable modern signing schemes with secure algorithms
    }

    buildTypes {
        release {
            isMinifyEnabled = true
            isShrinkResources = true

            // Only set signing config if it exists (not in F-Droid)
            if (System.getenv("FDROID") != "true") {
            }

            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
        debug {
            isMinifyEnabled = false
            applicationIdSuffix = ".debug"
            versionNameSuffix = "-DEBUG"
        }
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }

    testOptions {
        unitTests {
            isIncludeAndroidResources = true
        }
    }
}

dependencies {
    // Main app dependencies
    implementation("androidx.appcompat:appcompat:1.6.1")
    implementation("com.google.android.material:material:1.11.0")
    implementation("androidx.activity:activity:1.8.0")
    implementation("androidx.constraintlayout:constraintlayout:2.1.4")
    implementation("com.caverock:androidsvg:1.4")

    // Test dependencies
    testImplementation("junit:junit:4.13.2")
    testImplementation("org.mockito:mockito-core:4.11.0")
    testImplementation("androidx.test:core:1.5.0")

    // Android Test dependencies
    androidTestImplementation("androidx.test.ext:junit:1.1.5")
    androidTestImplementation("androidx.test.espresso:espresso-core:3.5.1")
    androidTestImplementation("org.mockito:mockito-android:4.11.0")

    implementation("androidx.documentfile:documentfile:1.0.1")
    implementation("androidx.preference:preference:1.2.1")
    implementation("androidx.swiperefreshlayout:swiperefreshlayout:1.1.0")

    implementation("androidx.cardview:cardview:1.0.0")
}