package org.ojrandom.paiesque.ui;

import android.app.Activity;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

public class ProgressManager {
    private final Activity activity;
    private final View progressIndicator;
    private final ProgressBar progressBar;
    private final TextView textProgressTitle;
    private final TextView textProgressStatus;

    public ProgressManager(Activity activity, View progressIndicator,
                           ProgressBar progressBar, TextView textProgressTitle,
                           TextView textProgressStatus) {
        this.activity = activity;
        this.progressIndicator = progressIndicator;
        this.progressBar = progressBar;
        this.textProgressTitle = textProgressTitle;
        this.textProgressStatus = textProgressStatus;
    }

    public void showProgress(boolean show) {
        activity.runOnUiThread(() -> {
            if (progressIndicator != null) {
                progressIndicator.setVisibility(show ? View.VISIBLE : View.GONE);
            }
        });
    }

    public void updateProgress(int progress, int max, String status) {
        activity.runOnUiThread(() -> {
            if (progressBar != null) {
                progressBar.setMax(max);
                progressBar.setProgress(progress);
            }
            updateProgressStatus(status); // Reuse existing method
        });
    }

    public void updateProgressStatus(String status) {
        activity.runOnUiThread(() -> {
            if (textProgressStatus != null) {
                textProgressStatus.setText(status);
            }
        });
    }

    public void showError(String errorMessage) {
        activity.runOnUiThread(() -> {
            if (textProgressStatus != null) {
                textProgressStatus.setText("Error: " + errorMessage);
            }
            if (textProgressTitle != null) {
                textProgressTitle.setText("Calculation Failed");
            }
        });
    }
}