package org.ojrandom.paiesque.data.sync;

import android.database.Cursor;
import org.ojrandom.paiesque.data.GadgetbridgeSyncSource;
import org.ojrandom.paiesque.logging.AppLogger;

import java.util.Map;

/**
 * Query handler for manufacturers with separate activity and heart rate tables.
 * Elegant implementation supporting both single and multi-table queries.
 */
public class TwoTableQueryHandler extends StandardQueryHandler {

    @Override
    public String buildQuery(String[] tableNames, long lastSyncTimestamp) {
        if (tableNames.length == 1) {
            // Single table fallback
            return super.buildQuery(tableNames[0], lastSyncTimestamp);
        } else if (tableNames.length == 2) {
            // JOIN query for two-table manufacturers (CMF, COLMI)
            return buildJoinQuery(tableNames[0], tableNames[1], lastSyncTimestamp);
        } else {
            throw new IllegalArgumentException(
                    "TwoTableQueryHandler supports 1-2 tables, got: " + tableNames.length);
        }
    }

    /**
     * Builds a JOIN query between activity and heart rate tables.
     */
    private String buildJoinQuery(String activityTable, String heartRateTable, long lastSyncTimestamp) {
        String query = "SELECT a.TIMESTAMP, a.DEVICE_ID, h.HEART_RATE " +
                "FROM " + activityTable + " a " +
                "INNER JOIN " + heartRateTable + " h " +
                "ON a.TIMESTAMP = h.TIMESTAMP AND a.DEVICE_ID = h.DEVICE_ID " +
                "WHERE a.TIMESTAMP > " + lastSyncTimestamp + " " +
                "ORDER BY a.TIMESTAMP";

        AppLogger.d(TAG, "Built JOIN query for: " + activityTable + " + " + heartRateTable);
        return query;
    }

    // extractRecord() is inherited from StandardQueryHandler - same column mapping
}